const express = require("express");
const cors = require("cors");
const morgan = require("morgan");
const http = require("http");
const userAuth = require("./middleware/userAuth");
const rateLimit = require('express-rate-limit');
const xss = require('xss-clean');
const helmet = require('helmet');

const limiter = rateLimit({
	windowMs: 15 * 60 * 1000, // 15 minutes
	limit: 100, // Limit each IP to 100 requests per `window` (here, per 15 minutes).
	standardHeaders: 'draft-7', // draft-6: `RateLimit-*` headers; draft-7: combined `RateLimit` header
	legacyHeaders: false, // Disable the `X-RateLimit-*` headers.
	// store: ... , // Use an external store for consistency across multiple server instances.
  message: "you have exceed the number of request"
});



const app = express();

app.use(cors());
app.use(morgan("dev"));
app.use(express.urlencoded({ extended: false }));
app.use(express.json());

app.use(helmet());

// Apply the rate limiting middleware to all requests.
app.use(limiter)

// make sure this comes before any routes
app.use(xss())

app.get("/get",userAuth, function (req, res, next) {
  res.send("hello starter");
});

// apis routes

// for set in orders
const createSetInOrder = require("./Apis/SetInOrder/Create");
const deleteSetInOrder = require("./Apis/SetInOrder/Delete");
const updateSetInOrder = require("./Apis/SetInOrder/Update");
const selectSetInOrder = require("./Apis/SetInOrder/Select");
//shine
const createShine = require("./Apis/Shine/Create");
const deleteShine = require("./Apis/Shine/Delete");
const updateShine = require("./Apis/Shine/Update");
const selectShine = require("./Apis/Shine/Select");
// sort
const createSort = require("./Apis/Sort/Create");
const deleteSort = require("./Apis/Sort/Delete");
const updateSort = require("./Apis/Sort/Update");
const selectSort = require("./Apis/Sort/Select");
// standardize
const createStandardize = require("./Apis/Standardize/Create");
const deleteStandardize = require("./Apis/Standardize/Delete");
const updateStandardize = require("./Apis/Standardize/Update");
const selectStandardize = require("./Apis/Standardize/Select");
// sustain
const createSustain = require("./Apis/Sustain/Create");
const deleteSustain = require("./Apis/Sustain/Delete");
const updateSustain = require("./Apis/Sustain/Update");
const selectSustain = require("./Apis/Sustain/Select");

//userFeedback
const createUserFeedback = require("./Apis/Feedback/Create");
const selectUserFeedback = require("./Apis/Feedback/Select");

//calender work
const createCalender = require("./Apis/Calender/Create");
const updateCalender = require("./Apis/Calender/Update");
const selectCalender = require("./Apis/Calender/Select");

//Area
const selectArea = require("./Apis/Area/select");

//middleware routes
// create set in order
app.use("/api/setinorder", userAuth, createSetInOrder);
app.use("/api/setinorder", userAuth, deleteSetInOrder);
app.use("/api/setinorder", userAuth, updateSetInOrder);
app.use("/api/setinorder", userAuth, selectSetInOrder);

app.use("/api/shine", userAuth, createShine);
app.use("/api/shine", userAuth, deleteShine);
app.use("/api/shine", userAuth, selectShine);
app.use("/api/shine", userAuth, updateShine);

app.use("/api/sort", userAuth, selectSort);
app.use("/api/sort", userAuth, updateSort);
app.use("/api/sort", userAuth, deleteSort);
app.use("/api/sort", userAuth, createSort);

app.use("/api/standardize", userAuth, createStandardize);
app.use("/api/standardize", userAuth, selectStandardize);
app.use("/api/standardize", userAuth, updateStandardize);
app.use("/api/standardize", userAuth, deleteStandardize);

app.use("/api/sustain", userAuth, createSustain);
app.use("/api/sustain", userAuth, selectSustain);
app.use("/api/sustain", userAuth, updateSustain);
app.use("/api/sustain", userAuth, deleteSustain);

//userFeedback
app.use("/api/feedback", userAuth, createUserFeedback);
app.use("/api/feedback", userAuth, selectUserFeedback);

//area
app.use("/api/area", userAuth, selectArea);

const server = http.createServer(app);
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => {
  console.log("Server is running on: localhost:", PORT);
});
